/*
 * Decompiled with CFR 0.152.
 */
package frink.text;

import frink.expr.az;
import frink.text.m;

public class NewUnicodeProcessor
implements m {
    @Override
    public int codePointAt(String string, int n2) throws az {
        try {
            return string.codePointAt(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new az("NewUnicodeProcessor.codePointAt:  Index " + n2 + " out of bounds.", null);
        }
    }

    @Override
    public int codePointBefore(String string, int n2) throws az {
        try {
            return string.codePointBefore(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new az("NewUnicodeProcessor.codePointBefore:  Index " + n2 + " out of bounds.", null);
        }
    }

    @Override
    public int offsetByCodePoints(String string, int n2, int n3) throws az {
        try {
            return string.offsetByCodePoints(n2, n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new az("NewUnicodeProcessor.offsetByCodePoints:  Invalid arguments:  index=" + n2 + ", codePointOffset=" + n3, null);
        }
    }

    @Override
    public StringBuffer appendCodePoint(StringBuffer stringBuffer, int n2) throws az {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new az("NewUnicodeProcessor.appendCodePoint:  Invalid code point.  Character was \\u" + Integer.toHexString(n2), null);
        }
        return stringBuffer.appendCodePoint(n2);
    }

    @Override
    public int codePointCount(String string, int n2, int n3) throws az {
        try {
            return string.codePointCount(n2, n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new az("NewUnicodeProcessor.codePointCount:  Invalid arguments:  beginIndex=" + n2 + ", endIndex=" + n3, null);
        }
    }

    @Override
    public int length(String string) {
        return string.codePointCount(0, string.length());
    }

    @Override
    public int logicalToRawIndex(String string, int n2) throws az {
        try {
            return string.offsetByCodePoints(0, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new az("NewUnicodeProcessor.logicalToRawIndex:  Invalid argument:  index=" + n2, null);
        }
    }

    @Override
    public int rawToLogicalIndex(String string, int n2) throws az {
        return this.codePointCount(string, 0, n2);
    }

    @Override
    public int indexOf(String string, String string2, int n2) throws az {
        try {
            int n3 = this.logicalToRawIndex(string, n2);
            int n4 = string.indexOf(string2, n3);
            if (n4 == -1) {
                return -1;
            }
            return this.rawToLogicalIndex(string, n4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new az("NewUnicodeProcessor.indexOf:  Invalid argument:  startAt=" + n2, null);
        }
    }

    @Override
    public int lastIndexOf(String string, String string2, int n2) throws az {
        try {
            int n3 = this.logicalToRawIndex(string, n2);
            int n4 = string.lastIndexOf(string2, n3);
            if (n4 == -1) {
                return -1;
            }
            return this.rawToLogicalIndex(string, n4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new az("NewUnicodeProcessor.lastIndexOf:  Invalid argument:  startAt=" + n2, null);
        }
    }

    @Override
    public String substrLen(String string, int n2, int n3) throws az {
        int n4;
        if (n3 < 0) {
            throw new az("NewUnicodeProcessor.substrLen: length was negative.", null);
        }
        int n5 = this.logicalToRawIndex(string, n2);
        try {
            n4 = this.offsetByCodePoints(string, n5, n3);
        }
        catch (az az2) {
            n4 = string.length();
        }
        return string.substring(n5, n4);
    }

    @Override
    public int getUnicodeCategoryID(int n2) {
        return Character.getType(n2);
    }

    @Override
    public String getUnicodeBlock(int n2) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(n2);
        if (unicodeBlock == null) {
            return null;
        }
        return unicodeBlock.toString();
    }
}

