/*
 * Decompiled with CFR 0.152.
 */
package frink.graphics;

import frink.expr.Environment;
import frink.expr.az;
import frink.expr.be;
import frink.graphics.BiggerBitSet;
import frink.graphics.BoundingBox2DFloat;
import frink.graphics.BoundingBox3DFloat;
import frink.graphics.CoordinateTransformer3DFloat;
import frink.graphics.Field3DFloat;
import frink.graphics.FrinkImage;
import frink.graphics.LinePoints;
import frink.graphics.LineSegment3DFloat;
import frink.graphics.MarchingCubes;
import frink.graphics.Plane3DFloat;
import frink.graphics.Point2DFloat;
import frink.graphics.Point2DFloatList;
import frink.graphics.Point3DDouble;
import frink.graphics.Point3DFloat;
import frink.graphics.Point3DInt;
import frink.graphics.Point3DIntList;
import frink.graphics.STLFormatter;
import frink.graphics.WavefrontObj;
import frink.graphics.a;
import frink.graphics.ag;
import frink.graphics.bl;
import java.util.Stack;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VoxelArray
implements Field3DFloat {
    private BiggerBitSet new;
    private int int;
    private int if;
    private int a;
    private int case;
    private int byte;
    private int try;
    private long do;
    private static final double for = Math.PI * 2;

    public VoxelArray(int n2, int n3, int n4) {
        this(0, n2, 0, n3, 0, n4, false);
    }

    public VoxelArray(int n2, int n3, int n4, boolean bl2) {
        this(n2, n3, n4);
        if (bl2) {
            long l2 = this.do * (long)n4;
            this.new.setRange(0L, l2);
        }
    }

    public VoxelArray(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        this.case = n2;
        this.byte = n4;
        this.try = n6;
        this.int = n3;
        this.if = n5;
        this.a = n7;
        this.do = (long)n3 * (long)n5;
        long l2 = this.do * (long)n7;
        this.new = new BiggerBitSet(l2);
        if (bl2) {
            this.new.setRange(0L, l2);
        }
    }

    public VoxelArray(VoxelArray voxelArray) {
        this.int = voxelArray.int;
        this.if = voxelArray.if;
        this.a = voxelArray.a;
        this.do = voxelArray.do;
        this.case = voxelArray.case;
        this.byte = voxelArray.byte;
        this.try = voxelArray.try;
        this.new = (BiggerBitSet)voxelArray.new.clone();
    }

    public VoxelArray(VoxelArray voxelArray, boolean bl2) {
        this(voxelArray.case, voxelArray.int, voxelArray.byte, voxelArray.if, voxelArray.try, voxelArray.a, bl2);
    }

    public static VoxelArray construct(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl2) {
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        if (d6 < d7) {
            d13 = d6;
            d12 = d7;
        } else {
            d13 = d7;
            d12 = d6;
        }
        if (d4 < d5) {
            d11 = d4;
            d10 = d5;
        } else {
            d11 = d5;
            d10 = d4;
        }
        if (d2 < d3) {
            d9 = d2;
            d8 = d3;
        } else {
            d9 = d3;
            d8 = d2;
        }
        int n2 = (int)Math.floor(d9);
        int n3 = (int)Math.ceil(d8);
        int n4 = (int)Math.floor(d11);
        int n5 = (int)Math.ceil(d10);
        int n6 = (int)Math.floor(d13);
        int n7 = (int)Math.ceil(d12);
        return new VoxelArray(n2, n3 - n2 + 1, n4, n5 - n4 + 1, n6, n7 - n6 + 1, bl2);
    }

    public static VoxelArray cube(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl2) {
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        if (d6 < d7) {
            d13 = d6;
            d12 = d7;
        } else {
            d13 = d7;
            d12 = d6;
        }
        if (d4 < d5) {
            d11 = d4;
            d10 = d5;
        } else {
            d11 = d5;
            d10 = d4;
        }
        if (d2 < d3) {
            d9 = d2;
            d8 = d3;
        } else {
            d9 = d3;
            d8 = d2;
        }
        int n2 = (int)Math.round(d9);
        int n3 = (int)Math.round(d8);
        int n4 = (int)Math.round(d11);
        int n5 = (int)Math.round(d10);
        int n6 = (int)Math.round(d13);
        int n7 = (int)Math.round(d12);
        return new VoxelArray(n2, n3 - n2 + 1, n4, n5 - n4 + 1, n6, n7 - n6 + 1, bl2);
    }

    public static VoxelArray construct(Point3DIntList point3DIntList) {
        BoundingBox3DFloat boundingBox3DFloat = point3DIntList.getBoundingBox();
        VoxelArray voxelArray = VoxelArray.construct(boundingBox3DFloat.getMinX(), boundingBox3DFloat.getMaxX(), boundingBox3DFloat.getMinY(), boundingBox3DFloat.getMaxY(), boundingBox3DFloat.getMinZ(), boundingBox3DFloat.getMaxZ(), false);
        int n2 = point3DIntList.getPointCount();
        int n3 = 0;
        while (n3 < n2) {
            Point3DInt point3DInt = point3DIntList.getPoint(n3);
            voxelArray.a(point3DInt, true);
            ++n3;
        }
        return voxelArray;
    }

    public static VoxelArray construct(BoundingBox3DFloat boundingBox3DFloat, boolean bl2) {
        return VoxelArray.construct(boundingBox3DFloat.getMinX(), boundingBox3DFloat.getMaxX(), boundingBox3DFloat.getMinY(), boundingBox3DFloat.getMaxY(), boundingBox3DFloat.getMinZ(), boundingBox3DFloat.getMaxZ(), bl2);
    }

    public long toIndex(long l2, long l3, long l4) throws IndexOutOfBoundsException {
        this.a(l2, l3, l4);
        return l2 - (long)this.case + (l3 - (long)this.byte) * (long)this.int + (l4 - (long)this.try) * this.do;
    }

    private long if(long l2, long l3, long l4) {
        return l2 - (long)this.case + (l3 - (long)this.byte) * (long)this.int + (l4 - (long)this.try) * this.do;
    }

    public void indexToXYZ(long l2, long[] lArray) {
        if (l2 >= (long)this.int * (long)this.if * (long)this.a) {
            throw new IndexOutOfBoundsException("VoxelArray.indexToXYZ:  Index (" + l2 + ") out of bounds.");
        }
        long l3 = l2 / this.do;
        lArray[2] = l3 + (long)this.try;
        long l4 = (l2 -= l3 * this.do) / (long)this.int;
        lArray[1] = l4 + (long)this.byte;
        lArray[0] = l2 - l4 * (long)this.int + (long)this.case;
    }

    public void setRange(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) throws IndexOutOfBoundsException {
        int n8;
        this.a((long)n2, (long)n4, (long)n6);
        this.a((long)n3, (long)n5, (long)n7);
        if (n2 > n3) {
            n8 = n2;
            n2 = n3;
            n3 = n8;
        }
        if (n4 > n5) {
            n8 = n4;
            n4 = n5;
            n5 = n8;
        }
        if (n6 > n7) {
            n8 = n6;
            n6 = n7;
            n7 = n8;
        }
        int n9 = n6;
        while (n9 <= n7) {
            int n10 = n4;
            while (n10 <= n5) {
                this.new.setRange(this.if(n2, n10, n9), this.if(n3, n10, n9) + 1L, bl2);
                ++n10;
            }
            ++n9;
        }
    }

    public void fillCube(float f2, float f3, float f4, float f5, float f6, float f7, boolean bl2) throws IndexOutOfBoundsException {
        this.setRange(Math.round(f2), Math.round(f3), Math.round(f4), Math.round(f5), Math.round(f6), Math.round(f7), bl2);
    }

    public void set(int n2, int n3, int n4, boolean bl2) throws IndexOutOfBoundsException {
        this.new.set(this.toIndex(n2, n3, n4), bl2);
    }

    public void set(Point3DInt point3DInt, boolean bl2) throws IndexOutOfBoundsException {
        this.new.set(this.toIndex(point3DInt.x, point3DInt.y, point3DInt.z), bl2);
    }

    private void a(int n2, int n3, int n4, boolean bl2) {
        this.new.set(this.if(n2, n3, n4), bl2);
    }

    private void a(Point3DInt point3DInt, boolean bl2) {
        this.new.set(this.if(point3DInt.x, point3DInt.y, point3DInt.z), bl2);
    }

    public boolean isInRange(long l2, long l3, long l4) {
        return l2 - (long)this.case >= 0L && l2 - (long)this.case < (long)this.int && l3 - (long)this.byte >= 0L && l3 - (long)this.byte < (long)this.if && l4 - (long)this.try >= 0L && l4 - (long)this.try < (long)this.a;
    }

    public boolean isInRange(Point3DInt point3DInt) {
        return this.isInRange(point3DInt.x, point3DInt.y, point3DInt.z);
    }

    private void a(long l2, long l3, long l4) throws IndexOutOfBoundsException {
        if (!this.isInRange(l2, l3, l4)) {
            throw new IndexOutOfBoundsException("VoxelArray.toIndex:  Indices (" + l2 + "," + l3 + "," + l4 + ") out of bounds.");
        }
    }

    public boolean get(int n2, int n3, int n4) throws IndexOutOfBoundsException {
        return this.new.get(this.toIndex(n2, n3, n4));
    }

    private boolean a(int n2, int n3, int n4) throws IndexOutOfBoundsException {
        return this.new.get(this.if(n2, n3, n4));
    }

    private boolean a(Point3DInt point3DInt) throws IndexOutOfBoundsException {
        return this.new.get(this.if(point3DInt.x, point3DInt.y, point3DInt.z));
    }

    public int getSizeX() {
        return this.int;
    }

    public int getSizeY() {
        return this.if;
    }

    public int getSizeZ() {
        return this.a;
    }

    public int getMinX() {
        return this.case;
    }

    public int getMinY() {
        return this.byte;
    }

    public int getMinZ() {
        return this.try;
    }

    public int getMaxX() {
        return this.case + this.int - 1;
    }

    public int getMaxY() {
        return this.byte + this.if - 1;
    }

    public int getMaxZ() {
        return this.try + this.a - 1;
    }

    public Point3DFloat getCenter() {
        return new Point3DFloat((float)(this.getMinX() + this.getMaxX()) / 2.0f, (float)(this.getMinY() + this.getMaxY()) / 2.0f, (float)(this.getMinZ() + this.getMaxZ()) / 2.0f);
    }

    public void translate(int n2, int n3, int n4) {
        this.case += n2;
        this.byte += n3;
        this.try += n4;
    }

    public float sampleFloat(float f2, float f3, float f4) {
        int n2 = (int)f2;
        int n3 = (int)f3;
        int n4 = (int)f4;
        if (this.isInRange(n2, n3, n4)) {
            return this.a(n2, n3, n4) ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public boolean sampleBoolean(int n2, int n3, int n4) {
        if (this.isInRange(n2, n3, n4)) {
            return this.a(n2, n3, n4);
        }
        return false;
    }

    public boolean sampleBoolean(Point3DInt point3DInt) {
        if (this.isInRange(point3DInt)) {
            return this.a(point3DInt);
        }
        return false;
    }

    public float sampleFloat(Point3DFloat point3DFloat) {
        return this.sampleFloat(point3DFloat.x, point3DFloat.y, point3DFloat.z);
    }

    public Vector triangulateHull() {
        return MarchingCubes.triangulateHull(this.getMinX() - 1, this.getMaxX() + 1, this.getSizeX() + 1, this.getMinY() - 1, this.getMaxY() + 1, this.getSizeY() + 1, this.getMinZ() - 1, this.getMaxZ() + 1, this.getSizeZ() + 1, this, 0.5f);
    }

    public String toObjFormat(String string) {
        return WavefrontObj.toObjFormat(this.triangulateHull(), string);
    }

    public String toObjFormat(String string, float f2) {
        return WavefrontObj.toObjFormat(this.triangulateHull(), string, f2);
    }

    public String toSTLFormat(String string) {
        return STLFormatter.toSTLFormat(this.triangulateHull(), string);
    }

    public String toSTLFormat(String string, float f2) {
        return STLFormatter.toSTLFormat(this.triangulateHull(), string, f2);
    }

    public Point3DIntList hullPoints() {
        int n2 = this.getMinX();
        int n3 = this.getMaxX();
        int n4 = this.getMinY();
        int n5 = this.getMaxY();
        int n6 = this.getMinZ();
        int n7 = this.getMaxZ();
        Point3DIntList point3DIntList = new Point3DIntList();
        int n8 = n6;
        while (n8 <= n7) {
            int n9 = n4;
            while (n9 <= n5) {
                int n10 = n2;
                while (n10 <= n3) {
                    if (!(!this.a(n10, n9, n8) || this.sampleBoolean(n10 - 1, n9, n8) && this.sampleBoolean(n10 + 1, n9, n8) && this.sampleBoolean(n10, n9 - 1, n8) && this.sampleBoolean(n10, n9 + 1, n8) && this.sampleBoolean(n10, n9, n8 - 1) && this.sampleBoolean(n10, n9, n8 + 1))) {
                        point3DIntList.addPoint(n10, n9, n8);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
        return point3DIntList;
    }

    public Point3DIntList externalHullPoints() {
        Stack<Point3DInt> stack = new Stack<Point3DInt>();
        int n2 = this.getMinX();
        int n3 = this.getMaxX();
        int n4 = this.getMinY();
        int n5 = this.getMaxY();
        int n6 = this.getMinSetZ();
        int n7 = this.getMaxSetZ();
        VoxelArray voxelArray = VoxelArray.construct(n2 - 1, n3 + 1, n4 - 1, n5 + 1, n6 - 1, n7 + 1, false);
        stack.push(new Point3DInt(n2 - 1, n4 - 1, n6 - 1));
        voxelArray.a(n2 - 1, n4 - 1, n6 - 1, true);
        Point3DIntList point3DIntList = new Point3DIntList();
        while (!stack.empty()) {
            Point3DInt point3DInt = (Point3DInt)stack.pop();
            if (this.isInRange(point3DInt) && this.a(point3DInt)) {
                point3DIntList.addPoint(point3DInt);
                continue;
            }
            int n8 = point3DInt.x;
            int n9 = n8 - 1;
            int n10 = point3DInt.y;
            int n11 = n10;
            int n12 = point3DInt.z;
            int n13 = n12;
            if (voxelArray.isInRange(n9, n11, n13) && !voxelArray.a(n9, n11, n13)) {
                stack.push(new Point3DInt(n9, n11, n13));
                voxelArray.a(n9, n11, n13, true);
            }
            if (voxelArray.isInRange(n9 = n8 + 1, n11, n13) && !voxelArray.a(n9, n11, n13)) {
                stack.push(new Point3DInt(n9, n11, n13));
                voxelArray.a(n9, n11, n13, true);
            }
            if (voxelArray.isInRange(n9 = n8, n11 = n10 - 1, n13) && !voxelArray.a(n9, n11, n13)) {
                stack.push(new Point3DInt(n9, n11, n13));
                voxelArray.a(n9, n11, n13, true);
            }
            if (voxelArray.isInRange(n9, n11 = n10 + 1, n13) && !voxelArray.a(n9, n11, n13)) {
                stack.push(new Point3DInt(n9, n11, n13));
                voxelArray.a(n9, n11, n13, true);
            }
            if (voxelArray.isInRange(n9, n11 = n10, n13 = n12 - 1) && !voxelArray.a(n9, n11, n13)) {
                stack.push(new Point3DInt(n9, n11, n13));
                voxelArray.a(n9, n11, n13, true);
            }
            if (!voxelArray.isInRange(n9, n11, n13 = n12 + 1) || voxelArray.a(n9, n11, n13)) continue;
            stack.push(new Point3DInt(n9, n11, n13));
            voxelArray.a(n9, n11, n13, true);
        }
        return point3DIntList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public VoxelArray floodFill(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        Stack<Point3DInt> stack = new Stack<Point3DInt>();
        VoxelArray voxelArray = VoxelArray.construct(n2, n3, n4, n5, n6, n7, false);
        VoxelArray voxelArray2 = VoxelArray.construct(n2, n3, n4, n5, n6, n7, false);
        if (!voxelArray2.isInRange(n8, n9, n10)) {
            System.err.println("VoxelArray.floodFill:  start point is not in bounds!");
            return voxelArray;
        }
        stack.push(new Point3DInt(n8, n9, n10));
        voxelArray2.a(n8, n9, n10, true);
        while (!stack.empty()) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            Point3DInt point3DInt = (Point3DInt)stack.pop();
            if (this.isInRange(point3DInt)) {
                if (this.a(point3DInt)) continue;
                voxelArray.a(point3DInt, true);
            }
            if (voxelArray2.isInRange(n16 = (n15 = point3DInt.x) - 1, n14 = (n13 = point3DInt.y), n12 = (n11 = point3DInt.z)) && !voxelArray2.a(n16, n14, n12)) {
                stack.push(new Point3DInt(n16, n14, n12));
                voxelArray2.a(n16, n14, n12, true);
            }
            if (voxelArray2.isInRange(n16 = n15 + 1, n14, n12) && !voxelArray2.a(n16, n14, n12)) {
                stack.push(new Point3DInt(n16, n14, n12));
                voxelArray2.a(n16, n14, n12, true);
            }
            if (voxelArray2.isInRange(n16 = n15, n14 = n13 - 1, n12) && !voxelArray2.a(n16, n14, n12)) {
                stack.push(new Point3DInt(n16, n14, n12));
                voxelArray2.a(n16, n14, n12, true);
            }
            if (voxelArray2.isInRange(n16, n14 = n13 + 1, n12) && !voxelArray2.a(n16, n14, n12)) {
                stack.push(new Point3DInt(n16, n14, n12));
                voxelArray2.a(n16, n14, n12, true);
            }
            if (voxelArray2.isInRange(n16, n14 = n13, n12 = n11 - 1) && !voxelArray2.a(n16, n14, n12)) {
                stack.push(new Point3DInt(n16, n14, n12));
                voxelArray2.a(n16, n14, n12, true);
            }
            if (!voxelArray2.isInRange(n16, n14, n12 = n11 + 1) || voxelArray2.a(n16, n14, n12)) continue;
            stack.push(new Point3DInt(n16, n14, n12));
            voxelArray2.a(n16, n14, n12, true);
        }
        return voxelArray;
    }

    public ag projectX(Environment environment) throws be {
        FrinkImage frinkImage = bl.a(this.if, this.a, false, "Voxel Array X", environment);
        int n2 = frink.graphics.a.a.if();
        double d2 = this.int == 0 ? 1.0 : (double)(this.int - 1);
        int n3 = 0;
        while (n3 < this.a) {
            int n4 = 0;
            while (n4 < this.if) {
                int n5 = -1;
                int n6 = this.int - 1;
                while (n6 >= 0) {
                    if (this.a(n6 + this.case, n4 + this.byte, n3 + this.try)) {
                        n5 = n6;
                        break;
                    }
                    --n6;
                }
                if (n5 == -1) {
                    frinkImage.setPixelPacked(n4, this.a - n3 - 1, n2);
                } else {
                    double d3 = Math.pow(0.5 - 0.5 * ((double)n5 / d2), 0.7);
                    int n7 = bl.a(d3, d3, d3);
                    frinkImage.setPixelPacked(n4, this.a - n3 - 1, n7);
                }
                ++n4;
            }
            ++n3;
        }
        return new ag(frinkImage);
    }

    public ag projectY(Environment environment) throws be {
        FrinkImage frinkImage = bl.a(this.int, this.a, false, "Voxel Array Y", environment);
        int n2 = frink.graphics.a.a.if();
        double d2 = this.if == 0 ? 1.0 : (double)(this.if - 1);
        int n3 = 0;
        while (n3 < this.a) {
            int n4 = 0;
            while (n4 < this.int) {
                int n5 = -1;
                int n6 = 0;
                while (n6 < this.if) {
                    if (this.a(n4 + this.case, n6 + this.byte, n3 + this.try)) {
                        n5 = n6;
                        break;
                    }
                    ++n6;
                }
                if (n5 == -1) {
                    frinkImage.setPixelPacked(n4, this.a - n3 - 1, n2);
                } else {
                    double d3 = Math.pow(0.5 - 0.5 * ((double)(this.if - n5 - 1) / d2), 0.7);
                    int n7 = bl.a(d3, d3, d3);
                    frinkImage.setPixelPacked(n4, this.a - n3 - 1, n7);
                }
                ++n4;
            }
            ++n3;
        }
        return new ag(frinkImage);
    }

    public ag projectZ(Environment environment) throws be {
        FrinkImage frinkImage = bl.a(this.int, this.if, false, "Voxel Array Z", environment);
        int n2 = frink.graphics.a.a.if();
        double d2 = this.a == 0 ? 1.0 : (double)(this.a - 1);
        int n3 = 0;
        while (n3 < this.if) {
            int n4 = 0;
            while (n4 < this.int) {
                int n5 = -1;
                int n6 = this.a - 1;
                while (n6 >= 0) {
                    if (this.a(n4 + this.case, n3 + this.byte, n6 + this.try)) {
                        n5 = n6;
                        break;
                    }
                    --n6;
                }
                if (n5 == -1) {
                    frinkImage.setPixelPacked(n4, this.if - n3 - 1, n2);
                } else {
                    double d3 = Math.pow(0.5 - 0.5 * ((double)n5 / d2), 0.7);
                    int n7 = bl.a(d3, d3, d3);
                    frinkImage.setPixelPacked(n4, this.if - n3 - 1, n7);
                }
                ++n4;
            }
            ++n3;
        }
        return new ag(frinkImage);
    }

    public void remove(VoxelArray voxelArray) {
        if (!this.intersectsWith(voxelArray)) {
            return;
        }
        if (this.hasSameBoundary(voxelArray)) {
            this.new.andNot(voxelArray.new);
            return;
        }
        int n2 = Math.max(this.getMinX(), voxelArray.getMinX());
        int n3 = Math.min(this.getMaxX(), voxelArray.getMaxX());
        int n4 = Math.max(this.getMinY(), voxelArray.getMinY());
        int n5 = Math.min(this.getMaxY(), voxelArray.getMaxY());
        int n6 = Math.max(this.getMinZ(), voxelArray.getMinSetZ());
        int n7 = Math.min(this.getMaxZ(), voxelArray.getMaxSetZ());
        int n8 = n6;
        while (n8 <= n7) {
            int n9 = n4;
            while (n9 <= n5) {
                int n10 = n2;
                while (n10 <= n3) {
                    if (voxelArray.a(n10, n9, n8)) {
                        this.a(n10, n9, n8, false);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
    }

    public void addAlongLine(VoxelArray voxelArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.paintAlongLine(voxelArray, n2, n3, n4, n5, n6, n7, n8, n9, n10, true);
    }

    public void removeAlongLine(VoxelArray voxelArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.paintAlongLine(voxelArray, n2, n3, n4, n5, n6, n7, n8, n9, n10, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintAlongLine(VoxelArray voxelArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl2) {
        int n11 = voxelArray.case;
        int n12 = voxelArray.byte;
        int n13 = voxelArray.try;
        int n14 = n8 - n11;
        int n15 = n9 - n12;
        int n16 = n10 - n13;
        try {
            Point3DIntList point3DIntList = LinePoints.line3DInt(n2, n3, n4, n5, n6, n7);
            int n17 = point3DIntList.getPointCount();
            int n18 = 0;
            while (n18 < n17) {
                Point3DInt point3DInt = point3DIntList.getPoint(n18);
                voxelArray.case = point3DInt.x - n14;
                voxelArray.byte = point3DInt.y - n15;
                voxelArray.try = point3DInt.z - n16;
                if (bl2) {
                    this.add(voxelArray);
                } else {
                    this.remove(voxelArray);
                }
                ++n18;
            }
            Object var23_22 = null;
            voxelArray.case = n11;
            voxelArray.byte = n12;
            voxelArray.try = n13;
        }
        catch (Throwable throwable) {
            Object var23_23 = null;
            voxelArray.case = n11;
            voxelArray.byte = n12;
            voxelArray.try = n13;
            throw throwable;
        }
    }

    public void add(VoxelArray voxelArray) {
        if (!this.intersectsWith(voxelArray)) {
            return;
        }
        if (this.hasSameBoundary(voxelArray)) {
            this.new.or(voxelArray.new);
            return;
        }
        int n2 = Math.max(this.getMinX(), voxelArray.getMinX());
        int n3 = Math.min(this.getMaxX(), voxelArray.getMaxX());
        int n4 = Math.max(this.getMinY(), voxelArray.getMinY());
        int n5 = Math.min(this.getMaxY(), voxelArray.getMaxY());
        int n6 = Math.max(this.getMinZ(), voxelArray.getMinSetZ());
        int n7 = Math.min(this.getMaxZ(), voxelArray.getMaxSetZ());
        int n8 = n6;
        while (n8 <= n7) {
            int n9 = n4;
            while (n9 <= n5) {
                int n10 = n2;
                while (n10 <= n3) {
                    if (voxelArray.a(n10, n9, n8)) {
                        this.a(n10, n9, n8, true);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
    }

    public boolean intersectsWith(VoxelArray voxelArray) {
        return this.getMaxX() >= voxelArray.getMinX() && voxelArray.getMaxX() >= this.getMinX() && this.getMaxY() >= voxelArray.getMinY() && voxelArray.getMaxY() >= this.getMinY() && this.getMaxZ() >= voxelArray.getMinZ() && voxelArray.getMaxZ() >= this.getMinZ();
    }

    public boolean intersectsWith(int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.getMaxX() >= n2 && n5 >= this.getMinX() && this.getMaxY() >= n3 && n6 >= this.getMinY() && this.getMaxZ() >= n4 && n7 >= this.getMinZ();
    }

    public static VoxelArray union(VoxelArray voxelArray, VoxelArray voxelArray2) {
        if (voxelArray == null) {
            return new VoxelArray(voxelArray2);
        }
        if (voxelArray2 == null) {
            return new VoxelArray(voxelArray);
        }
        int n2 = Math.min(voxelArray.getMinX(), voxelArray2.getMinX());
        int n3 = Math.max(voxelArray.getMaxX(), voxelArray2.getMaxX());
        int n4 = n3 - n2 + 1;
        int n5 = Math.min(voxelArray.getMinY(), voxelArray2.getMinY());
        int n6 = Math.max(voxelArray.getMaxY(), voxelArray2.getMaxY());
        int n7 = n6 - n5 + 1;
        int n8 = Math.min(voxelArray.getMinZ(), voxelArray2.getMinZ());
        int n9 = Math.max(voxelArray.getMaxZ(), voxelArray2.getMaxZ());
        int n10 = n9 - n8 + 1;
        VoxelArray voxelArray3 = new VoxelArray(n2, n4, n5, n7, n8, n10, false);
        voxelArray3.add(voxelArray);
        voxelArray3.add(voxelArray2);
        return voxelArray3;
    }

    public VoxelArray union(VoxelArray voxelArray) {
        return VoxelArray.union(this, voxelArray);
    }

    public void invert() {
        this.new.flip(0L, (long)this.int * (long)this.if * (long)this.a);
    }

    public long volume() {
        return (long)this.int * (long)this.if * (long)this.a;
    }

    public boolean hasSameBoundary(VoxelArray voxelArray) {
        return this.case == voxelArray.case && this.byte == voxelArray.byte && this.try == voxelArray.try && this.int == voxelArray.int && this.if == voxelArray.if && this.a == voxelArray.a;
    }

    public static VoxelArray makeSphere(float f2) {
        int n2;
        int n3 = Math.round(f2);
        int n4 = n2 = Math.round(f2);
        float f3 = f2 * f2;
        VoxelArray voxelArray = VoxelArray.construct(-n3, n2, -n3, n2, -n3, n2, false);
        int n5 = -n3;
        while (n5 <= n4) {
            float f4 = (float)n5 * (float)n5;
            int n6 = -n3;
            while (n6 <= n4) {
                float f5 = (float)n6 * (float)n6;
                float f6 = f3 - f5 - f4;
                if (!(f6 < 0.0f)) {
                    int n7 = (int)Math.round(Math.sqrt(f6));
                    voxelArray.new.setRange(voxelArray.toIndex(-n7, n6, n5), voxelArray.toIndex(n7, n6, n5) + 1L);
                }
                ++n6;
            }
            ++n5;
        }
        return voxelArray;
    }

    public static VoxelArray makeSpheroid(float f2, float f3, float f4) {
        int n2 = (int)Math.floor(-Math.abs(f2));
        int n3 = (int)Math.ceil(Math.abs(f2));
        int n4 = (int)Math.floor(-Math.abs(f3));
        int n5 = (int)Math.ceil(Math.abs(f3));
        int n6 = (int)Math.floor(-Math.abs(f4));
        int n7 = (int)Math.ceil(Math.abs(f4));
        float f5 = f2 * f2;
        float f6 = f3 * f3;
        float f7 = f4 * f4;
        VoxelArray voxelArray = VoxelArray.construct(n2, n3, n4, n5, n6, n7, false);
        int n8 = n6;
        while (n8 <= n7) {
            float f8 = (float)n8 * (float)n8;
            float f9 = f8 / f7;
            int n9 = n4;
            while (n9 <= n5) {
                float f10 = (float)n9 * (float)n9;
                float f11 = f10 / f6;
                float f12 = f5 * (1.0f - f11 - f9);
                if (!(f12 < 0.0f)) {
                    int n10 = (int)Math.round(Math.sqrt(f12));
                    voxelArray.new.setRange(voxelArray.toIndex(-n10, n9, n8), voxelArray.toIndex(n10, n9, n8) + 1L);
                }
                ++n9;
            }
            ++n8;
        }
        return voxelArray;
    }

    public static VoxelArray makeCylinder(Point3DFloat point3DFloat, Point3DFloat point3DFloat2, float f2) {
        return VoxelArray.makeCylinder(point3DFloat.x, point3DFloat.y, point3DFloat.z, point3DFloat2.x, point3DFloat2.y, point3DFloat2.z, f2);
    }

    public static VoxelArray makeCylinder(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        Point3DFloat point3DFloat;
        LineSegment3DFloat lineSegment3DFloat = new LineSegment3DFloat(f2, f3, f4, f5, f6, f7);
        Point3DFloat point3DFloat2 = lineSegment3DFloat.p1;
        Point3DFloat point3DFloat3 = lineSegment3DFloat.p2;
        if (point3DFloat2.x > point3DFloat3.x) {
            point3DFloat = point3DFloat3;
            point3DFloat3 = point3DFloat2;
            point3DFloat2 = point3DFloat;
        }
        float f9 = point3DFloat2.x - point3DFloat3.x;
        float f10 = point3DFloat2.y - point3DFloat3.y;
        float f11 = point3DFloat2.z - point3DFloat3.z;
        float f12 = f9 * f9 + f10 * f10 + f11 * f11;
        double d2 = Math.sqrt((f10 * f10 + f11 * f11) / f12);
        int n2 = (int)Math.floor((double)point3DFloat2.x - d2 * (double)f8);
        int n3 = (int)Math.ceil((double)point3DFloat3.x + d2 * (double)f8);
        if (point3DFloat2.y > point3DFloat3.y) {
            point3DFloat = point3DFloat3;
            point3DFloat3 = point3DFloat2;
            point3DFloat2 = point3DFloat;
        }
        f9 = point3DFloat2.x - point3DFloat3.x;
        f10 = point3DFloat2.y - point3DFloat3.y;
        f11 = point3DFloat2.z - point3DFloat3.z;
        double d3 = Math.sqrt((f9 * f9 + f11 * f11) / f12);
        int n4 = (int)Math.floor((double)point3DFloat2.y - d3 * (double)f8);
        int n5 = (int)Math.ceil((double)point3DFloat3.y + d3 * (double)f8);
        if (point3DFloat2.z > point3DFloat3.z) {
            point3DFloat = point3DFloat3;
            point3DFloat3 = point3DFloat2;
            point3DFloat2 = point3DFloat;
        }
        f9 = point3DFloat2.x - point3DFloat3.x;
        f10 = point3DFloat2.y - point3DFloat3.y;
        f11 = point3DFloat2.z - point3DFloat3.z;
        double d4 = Math.sqrt((f9 * f9 + f10 * f10) / f12);
        int n6 = (int)Math.floor((double)point3DFloat2.z - d4 * (double)f8);
        int n7 = (int)Math.ceil((double)point3DFloat3.z + d4 * (double)f8);
        VoxelArray voxelArray = new VoxelArray(n2, n3 - n2 + 1, n4, n5 - n4 + 1, n6, n7 - n6 + 1, false);
        voxelArray.drawCylinder(f2, f3, f4, f5, f6, f7, f8);
        return voxelArray;
    }

    public void drawCylinder(Point3DFloat point3DFloat, Point3DFloat point3DFloat2, float f2) {
        this.drawCylinder(point3DFloat.x, point3DFloat.y, point3DFloat.z, point3DFloat2.x, point3DFloat2.y, point3DFloat2.z, f2);
    }

    public void drawCylinder(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = (int)Math.floor(Math.min(f2, f5) - f8);
        if (!this.intersectsWith(n7, n6 = (int)Math.floor(Math.min(f3, f6) - f8), n5 = (int)Math.floor(Math.min(f4, f7) - f8), n4 = (int)Math.ceil(Math.max(f2, f5) + f8), n3 = (int)Math.ceil(Math.max(f3, f6) + f8), n2 = (int)Math.ceil(Math.max(f4, f7) + f8))) {
            return;
        }
        n7 = Math.max(this.getMinX(), n7);
        n6 = Math.max(this.getMinY(), n6);
        n5 = Math.max(this.getMinZ(), n5);
        n4 = Math.min(this.getMaxX(), n4);
        n3 = Math.min(this.getMaxY(), n3);
        n2 = Math.min(this.getMaxZ(), n2);
        LineSegment3DFloat lineSegment3DFloat = new LineSegment3DFloat(f2, f3, f4, f5, f6, f7);
        int n8 = n5;
        while (n8 <= n2) {
            int n9 = n6;
            while (n9 <= n3) {
                int n10 = n7;
                while (n10 <= n4) {
                    if (lineSegment3DFloat.inCylinder(n10, n9, n8, f8)) {
                        this.set(n10, n9, n8, true);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
    }

    public static VoxelArray makeTaperedCylinder(Point3DFloat point3DFloat, Point3DFloat point3DFloat2, float f2, float f3) {
        return VoxelArray.makeTaperedCylinder(point3DFloat.x, point3DFloat.y, point3DFloat.z, point3DFloat2.x, point3DFloat2.y, point3DFloat2.z, f2, f3);
    }

    public static VoxelArray makeTaperedCylinder(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        LineSegment3DFloat lineSegment3DFloat = new LineSegment3DFloat(f2, f3, f4, f5, f6, f7);
        int n2 = (int)Math.floor(Math.min(f2 - f8, f5 - f9));
        int n3 = (int)Math.floor(Math.min(f3 - f8, f6 - f9));
        int n4 = (int)Math.floor(Math.min(f4 - f8, f7 - f9));
        int n5 = (int)Math.ceil(Math.max(f2 + f8, f5 + f9));
        int n6 = (int)Math.ceil(Math.max(f3 + f8, f6 + f9));
        int n7 = (int)Math.ceil(Math.max(f4 + f8, f7 + f9));
        VoxelArray voxelArray = new VoxelArray(n2, n5 - n2 + 1, n3, n6 - n3 + 1, n4, n7 - n4 + 1, false);
        voxelArray.drawTaperedCylinder(f2, f3, f4, f5, f6, f7, f8, f9);
        return voxelArray;
    }

    public void drawTaperedCylinder(Point3DFloat point3DFloat, Point3DFloat point3DFloat2, float f2, float f3) {
        this.drawTaperedCylinder(point3DFloat.x, point3DFloat.y, point3DFloat.z, point3DFloat2.x, point3DFloat2.y, point3DFloat2.z, f2, f3);
    }

    public void drawTaperedCylinder(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = (int)Math.floor(Math.min(f2 - f8, f5 - f9));
        if (!this.intersectsWith(n7, n6 = (int)Math.floor(Math.min(f3 - f8, f6 - f9)), n5 = (int)Math.floor(Math.min(f4 - f8, f7 - f9)), n4 = (int)Math.ceil(Math.max(f2 + f8, f5 + f9)), n3 = (int)Math.ceil(Math.max(f3 + f8, f6 + f9)), n2 = (int)Math.ceil(Math.max(f4 + f8, f7 + f9)))) {
            return;
        }
        n7 = Math.max(this.getMinX(), n7);
        n6 = Math.max(this.getMinY(), n6);
        n5 = Math.max(this.getMinZ(), n5);
        n4 = Math.min(this.getMaxX(), n4);
        n3 = Math.min(this.getMaxY(), n3);
        n2 = Math.min(this.getMaxZ(), n2);
        LineSegment3DFloat lineSegment3DFloat = new LineSegment3DFloat(f2, f3, f4, f5, f6, f7);
        int n8 = n5;
        while (n8 <= n2) {
            int n9 = n6;
            while (n9 <= n3) {
                int n10 = n7;
                while (n10 <= n4) {
                    if (lineSegment3DFloat.inTaperedCylinder(n10, n9, n8, f8, f9)) {
                        this.set(n10, n9, n8, true);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
    }

    public static VoxelArray makeCappedCylinder(Point3DFloat point3DFloat, Point3DFloat point3DFloat2, float f2) {
        return VoxelArray.makeCappedCylinder(point3DFloat.x, point3DFloat.y, point3DFloat.z, point3DFloat2.x, point3DFloat2.y, point3DFloat2.z, f2);
    }

    public static VoxelArray makeCappedCylinder(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        LineSegment3DFloat lineSegment3DFloat = new LineSegment3DFloat(f2, f3, f4, f5, f6, f7);
        int n2 = (int)Math.floor(Math.min(f2, f5) - f8);
        int n3 = (int)Math.floor(Math.min(f3, f6) - f8);
        int n4 = (int)Math.floor(Math.min(f4, f7) - f8);
        int n5 = (int)Math.ceil(Math.max(f2, f5) + f8);
        int n6 = (int)Math.ceil(Math.max(f3, f6) + f8);
        int n7 = (int)Math.ceil(Math.max(f4, f7) + f8);
        VoxelArray voxelArray = new VoxelArray(n2, n5 - n2 + 1, n3, n6 - n3 + 1, n4, n7 - n4 + 1, false);
        voxelArray.drawCappedCylinder(f2, f3, f4, f5, f6, f7, f8);
        return voxelArray;
    }

    public void drawCappedCylinder(Point3DFloat point3DFloat, Point3DFloat point3DFloat2, float f2) {
        this.drawCappedCylinder(point3DFloat.x, point3DFloat.y, point3DFloat.z, point3DFloat2.x, point3DFloat2.y, point3DFloat2.z, f2);
    }

    public void drawCappedCylinder(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = (int)Math.floor(Math.min(f2, f5) - f8);
        if (!this.intersectsWith(n7, n6 = (int)Math.floor(Math.min(f3, f6) - f8), n5 = (int)Math.floor(Math.min(f4, f7) - f8), n4 = (int)Math.ceil(Math.max(f2, f5) + f8), n3 = (int)Math.ceil(Math.max(f3, f6) + f8), n2 = (int)Math.ceil(Math.max(f4, f7) + f8))) {
            return;
        }
        n7 = Math.max(this.getMinX(), n7);
        n6 = Math.max(this.getMinY(), n6);
        n5 = Math.max(this.getMinZ(), n5);
        n4 = Math.min(this.getMaxX(), n4);
        n3 = Math.min(this.getMaxY(), n3);
        n2 = Math.min(this.getMaxZ(), n2);
        LineSegment3DFloat lineSegment3DFloat = new LineSegment3DFloat(f2, f3, f4, f5, f6, f7);
        int n8 = n5;
        while (n8 <= n2) {
            int n9 = n6;
            while (n9 <= n3) {
                int n10 = n7;
                while (n10 <= n4) {
                    if (lineSegment3DFloat.distance(n10, n9, n8) <= f8) {
                        this.set(n10, n9, n8, true);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
    }

    public static VoxelArray makeTaperedCappedCylinder(Point3DFloat point3DFloat, Point3DFloat point3DFloat2, float f2, float f3) {
        return VoxelArray.makeTaperedCappedCylinder(point3DFloat.x, point3DFloat.y, point3DFloat.z, point3DFloat2.x, point3DFloat2.y, point3DFloat2.z, f2, f3);
    }

    public static VoxelArray makeTaperedCappedCylinder(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        LineSegment3DFloat lineSegment3DFloat = new LineSegment3DFloat(f2, f3, f4, f5, f6, f7);
        int n2 = (int)Math.floor(Math.min(f2 - f8, f5 - f9));
        int n3 = (int)Math.floor(Math.min(f3 - f8, f6 - f9));
        int n4 = (int)Math.floor(Math.min(f4 - f8, f7 - f9));
        int n5 = (int)Math.ceil(Math.max(f2 + f8, f5 + f9));
        int n6 = (int)Math.ceil(Math.max(f3 + f8, f6 + f9));
        int n7 = (int)Math.ceil(Math.max(f4 + f8, f7 + f9));
        VoxelArray voxelArray = new VoxelArray(n2, n5 - n2 + 1, n3, n6 - n3 + 1, n4, n7 - n4 + 1, false);
        voxelArray.drawTaperedCappedCylinder(f2, f3, f4, f5, f6, f7, f8, f9);
        return voxelArray;
    }

    public void drawTaperedCappedCylinder(Point3DFloat point3DFloat, Point3DFloat point3DFloat2, float f2, float f3) {
        this.drawTaperedCappedCylinder(point3DFloat.x, point3DFloat.y, point3DFloat.z, point3DFloat2.x, point3DFloat2.y, point3DFloat2.z, f2, f3);
    }

    public void drawTaperedCappedCylinder(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = (int)Math.floor(Math.min(f2 - f8, f5 - f9));
        if (!this.intersectsWith(n7, n6 = (int)Math.floor(Math.min(f3 - f8, f6 - f9)), n5 = (int)Math.floor(Math.min(f4 - f8, f7 - f9)), n4 = (int)Math.ceil(Math.max(f2 + f8, f5 + f9)), n3 = (int)Math.ceil(Math.max(f3 + f8, f6 + f9)), n2 = (int)Math.ceil(Math.max(f4 + f8, f7 + f9)))) {
            return;
        }
        n7 = Math.max(this.getMinX(), n7);
        n6 = Math.max(this.getMinY(), n6);
        n5 = Math.max(this.getMinZ(), n5);
        n4 = Math.min(this.getMaxX(), n4);
        n3 = Math.min(this.getMaxY(), n3);
        n2 = Math.min(this.getMaxZ(), n2);
        LineSegment3DFloat lineSegment3DFloat = new LineSegment3DFloat(f2, f3, f4, f5, f6, f7);
        int n8 = n5;
        while (n8 <= n2) {
            int n9 = n6;
            while (n9 <= n3) {
                int n10 = n7;
                while (n10 <= n4) {
                    if (lineSegment3DFloat.inTaperedCappedCylinder(n10, n9, n8, f8, f9)) {
                        this.set(n10, n9, n8, true);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
    }

    public void removeOutside(Plane3DFloat plane3DFloat) {
        int n2 = this.getMaxX();
        int n3 = this.getMaxY();
        int n4 = this.getMaxSetZ();
        int n5 = this.getMinSetZ();
        while (n5 <= n4) {
            int n6 = this.getMinY();
            while (n6 <= n3) {
                int n7 = this.getMinX();
                while (n7 <= n2) {
                    if (!plane3DFloat.isInside(n7, n6, n5)) {
                        this.a(n7, n6, n5, false);
                    }
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
    }

    public static VoxelArray extrudeZ(FrinkImage frinkImage, int n2) throws be {
        int n3 = n2 / 2;
        int n4 = n3 - n2 + 1;
        return VoxelArray.extrudeZ(frinkImage, n4, n3);
    }

    public static VoxelArray extrudeZ(FrinkImage frinkImage, int n2, int n3) throws be {
        int n4;
        int n5 = frinkImage.getWidth();
        int n6 = frinkImage.getHeight();
        if (n2 > n3) {
            n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        n4 = n3 - n2 + 1;
        VoxelArray voxelArray = new VoxelArray(n5, n6, n4, false);
        int n7 = 0;
        while (n7 < n6) {
            int n8 = 0;
            while (n8 < n5) {
                short s2 = bl.a(frinkImage.getPixelPacked(n8, n7), 255);
                if (s2 < 128) {
                    voxelArray.setRange(n8, n8, n6 - n7 - 1, n6 - n7 - 1, 0, n4 - 1, true);
                }
                ++n8;
            }
            ++n7;
        }
        voxelArray.translate(-n5 / 2, -n6 / 2, n2);
        return voxelArray;
    }

    public static VoxelArray extrudeOnPlane(FrinkImage frinkImage, float f2, float f3, float f4, float f5, float f6, float f7, float f8, double d2) throws be, az {
        CoordinateTransformer3DFloat coordinateTransformer3DFloat = CoordinateTransformer3DFloat.makeVerticalToPlane(f2, f3, f4, f5, f6, f7, d2);
        VoxelArray voxelArray = VoxelArray.extrudeZ(frinkImage, Math.round(f8));
        return voxelArray.transform(coordinateTransformer3DFloat);
    }

    public static VoxelArray strokeZ(Point2DFloatList point2DFloatList, VoxelArray voxelArray, float f2, float f3, float f4, boolean bl2) {
        BoundingBox2DFloat boundingBox2DFloat = point2DFloatList.getBoundingBox();
        boundingBox2DFloat = boundingBox2DFloat.expand(f2 - (float)voxelArray.getMinX(), f3 - (float)voxelArray.getMinY(), (float)voxelArray.getMaxX() - f2, (float)voxelArray.getMaxY() - f3);
        float f5 = f4 - (f4 - (float)voxelArray.getMinZ());
        float f6 = f4 + ((float)voxelArray.getMaxZ() - f4);
        VoxelArray voxelArray2 = VoxelArray.construct(boundingBox2DFloat.getMinX(), boundingBox2DFloat.getMaxX(), boundingBox2DFloat.getMinY(), boundingBox2DFloat.getMaxY(), f5, f6, false);
        int n2 = Math.round(boundingBox2DFloat.getMaxX());
        int n3 = Math.round(boundingBox2DFloat.getMaxY());
        int n4 = Math.round(f5);
        int n5 = Math.round(f6);
        int n6 = point2DFloatList.getPointCount();
        Point2DFloat point2DFloat = point2DFloatList.getPoint(0);
        Point2DFloat point2DFloat2 = null;
        int n7 = n6 - 1;
        if (bl2) {
            ++n7;
        }
        int n8 = Math.round(f2);
        int n9 = Math.round(f3);
        int n10 = Math.round(f4);
        int n11 = 1;
        while (n11 <= n7) {
            point2DFloat2 = point2DFloatList.getPoint(n11 % n6);
            voxelArray2.addAlongLine(voxelArray, Math.round(point2DFloat.x), Math.round(point2DFloat.y), n10, Math.round(point2DFloat2.x), Math.round(point2DFloat2.y), n10, n8, n9, n10);
            point2DFloat = point2DFloat2;
            ++n11;
        }
        return voxelArray2;
    }

    public static VoxelArray strokeZ(Point2DFloatList point2DFloatList, float f2, float f3, float f4, boolean bl2) {
        if (f2 > f3) {
            float f5 = f2;
            f2 = f3;
            f3 = f5;
        }
        VoxelArray voxelArray = VoxelArray.makeCylinder(0.0f, 0.0f, f2, 0.0f, 0.0f, f3, f4);
        float f6 = (f2 + f3) / 2.0f;
        return VoxelArray.strokeZ(point2DFloatList, voxelArray, 0.0f, 0.0f, f6, bl2);
    }

    public static VoxelArray strokeZTapered(Point2DFloatList point2DFloatList, float f2, float f3, float f4, float f5, boolean bl2) {
        if (f2 > f3) {
            float f6 = f2;
            f2 = f3;
            f3 = f6;
            f6 = f4;
            f4 = f5;
            f5 = f6;
        }
        VoxelArray voxelArray = VoxelArray.makeTaperedCylinder(0.0f, 0.0f, f2, 0.0f, 0.0f, f3, f4, f5);
        float f7 = (f2 + f3) / 2.0f;
        return VoxelArray.strokeZ(point2DFloatList, voxelArray, 0.0f, 0.0f, f7, bl2);
    }

    public static VoxelArray extrudeZ(Point2DFloatList point2DFloatList, float f2, float f3) {
        if (f2 > f3) {
            float f4 = f2;
            f2 = f3;
            f3 = f4;
        }
        BoundingBox2DFloat boundingBox2DFloat = point2DFloatList.getBoundingBox();
        VoxelArray voxelArray = VoxelArray.construct(boundingBox2DFloat.getMinX(), boundingBox2DFloat.getMaxX(), boundingBox2DFloat.getMinY(), boundingBox2DFloat.getMaxY(), f2, f3, false);
        int n2 = Math.round(boundingBox2DFloat.getMaxX());
        int n3 = Math.round(boundingBox2DFloat.getMaxY());
        int n4 = Math.round(f2);
        int n5 = Math.round(f3);
        int n6 = Math.round(boundingBox2DFloat.getMinY());
        while (n6 <= n3) {
            int n7 = Math.round(boundingBox2DFloat.getMinX());
            while (n7 <= n2) {
                if (point2DFloatList.isInside(n7, n6)) {
                    voxelArray.setRange(n7, n7, n6, n6, n4, n5, true);
                }
                ++n7;
            }
            ++n6;
        }
        return voxelArray;
    }

    public static VoxelArray extrudeZTapered(Point2DFloatList point2DFloatList, float f2, float f3, float f4, float f5) {
        Point2DFloat point2DFloat = point2DFloatList.getCentroid();
        return VoxelArray.extrudeZTapered(point2DFloatList, f2, f3, point2DFloat.x, point2DFloat.y, f4, f5);
    }

    public static VoxelArray extrudeZTapered(Point2DFloatList point2DFloatList, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = Math.max(f6, f7);
        BoundingBox2DFloat boundingBox2DFloat = point2DFloatList.getBoundingBox().scaleAround(f4, f5, f8);
        VoxelArray voxelArray = VoxelArray.construct(boundingBox2DFloat.getMinX(), boundingBox2DFloat.getMaxX(), boundingBox2DFloat.getMinY(), boundingBox2DFloat.getMaxY(), f2, f3, false);
        int n2 = Math.round(boundingBox2DFloat.getMaxX());
        int n3 = Math.round(boundingBox2DFloat.getMaxY());
        int n4 = Math.round(f2);
        int n5 = Math.round(f3);
        float f9 = f7 - f6;
        float f10 = f3 - f2;
        float f11 = f9 / f10;
        int n6 = n4;
        while (n6 <= n5) {
            float f12 = f6 + f11 * ((float)n6 - f2);
            Point2DFloatList point2DFloatList2 = point2DFloatList.scaleAround(f4, f5, f12);
            int n7 = Math.round(boundingBox2DFloat.getMinY());
            while (n7 <= n3) {
                int n8 = Math.round(boundingBox2DFloat.getMinX());
                while (n8 <= n2) {
                    if (point2DFloatList2.isInside(n8, n7)) {
                        voxelArray.setRange(n8, n8, n7, n7, n6, n6, true);
                    }
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        return voxelArray;
    }

    public static VoxelArray extrudeZTapered(Point2DFloatList point2DFloatList, float f2, float f3, float f4, float f5, float f6, float f7, double d2, double d3) {
        Point2DFloatList point2DFloatList2;
        boolean bl2 = d2 == d3;
        boolean bl3 = f6 == f7;
        int n2 = Math.round(f2);
        int n3 = Math.round(f3);
        int n4 = n3 - n2 + 1;
        Point2DFloatList[] point2DFloatListArray = null;
        if (bl2) {
            point2DFloatList = point2DFloatList.rotateAround(f4, f5, d2);
        }
        if (bl3) {
            point2DFloatList = point2DFloatList.scaleAround(f4, f5, f6);
        }
        if (!bl2 || !bl3) {
            point2DFloatListArray = new Point2DFloatList[n4];
        }
        BoundingBox2DFloat boundingBox2DFloat = new BoundingBox2DFloat();
        float f8 = f7 - f6;
        float f9 = f3 - f2;
        float f10 = f8 / f9;
        double d4 = d3 - d2;
        double d5 = d4 / (double)f9;
        int n5 = n2;
        while (n5 <= n3) {
            if (bl3) {
                point2DFloatList2 = point2DFloatList;
            } else {
                float f11 = f6 + f10 * ((float)n5 - f2);
                point2DFloatList2 = point2DFloatList.scaleAround(f4, f5, f11);
            }
            if (!bl2) {
                double d6 = d2 + d5 * (double)((float)n5 - f2);
                point2DFloatList2 = point2DFloatList2.rotateAround(f4, f5, d6);
            }
            boundingBox2DFloat = BoundingBox2DFloat.union(boundingBox2DFloat, point2DFloatList2.getBoundingBox());
            if (point2DFloatListArray != null) {
                point2DFloatListArray[n5 - n2] = point2DFloatList2;
            }
            ++n5;
        }
        VoxelArray voxelArray = VoxelArray.construct(boundingBox2DFloat.getMinX(), boundingBox2DFloat.getMaxX(), boundingBox2DFloat.getMinY(), boundingBox2DFloat.getMaxY(), f2, f3, false);
        int n6 = Math.round(boundingBox2DFloat.getMaxX());
        int n7 = Math.round(boundingBox2DFloat.getMaxY());
        int n8 = n2;
        while (n8 <= n3) {
            int n9 = n8 - n2;
            point2DFloatList2 = point2DFloatListArray == null ? point2DFloatList : point2DFloatListArray[n9];
            int n10 = Math.round(boundingBox2DFloat.getMinY());
            while (n10 <= n7) {
                int n11 = Math.round(boundingBox2DFloat.getMinX());
                while (n11 <= n6) {
                    if (point2DFloatList2.isInside(n11, n10)) {
                        voxelArray.setRange(n11, n11, n10, n10, n8, n8, true);
                    }
                    ++n11;
                }
                ++n10;
            }
            ++n8;
        }
        return voxelArray;
    }

    public static VoxelArray extrudeTapered(Point2DFloatList point2DFloatList, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, double d2) throws az {
        float f12 = f5 - f2;
        float f13 = f6 - f3;
        float f14 = f7 - f4;
        double d3 = Math.sqrt(f12 * f12 + f13 * f13 + f14 * f14);
        CoordinateTransformer3DFloat coordinateTransformer3DFloat = CoordinateTransformer3DFloat.makeVerticalToLine(f2, f3, f4, f5, f6, f7, d2);
        VoxelArray voxelArray = VoxelArray.extrudeZTapered(point2DFloatList, 0.0f, (float)d3, f8, f9, f10, f11);
        return voxelArray.transform(coordinateTransformer3DFloat);
    }

    public static VoxelArray extrudeTaperedRotated(Point2DFloatList point2DFloatList, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, double d2, double d3) throws az {
        float f12 = f5 - f2;
        float f13 = f6 - f3;
        float f14 = f7 - f4;
        double d4 = Math.sqrt(f12 * f12 + f13 * f13 + f14 * f14);
        CoordinateTransformer3DFloat coordinateTransformer3DFloat = CoordinateTransformer3DFloat.makeVerticalToLine(f2, f3, f4, f5, f6, f7, 0.0);
        VoxelArray voxelArray = VoxelArray.extrudeZTapered(point2DFloatList, 0.0f, (float)d4, f8, f9, f10, f11, d2, d3);
        return voxelArray.transform(coordinateTransformer3DFloat);
    }

    public static VoxelArray makeRoundedCube(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        if (f2 < f3) {
            f14 = f2;
            f13 = f3;
        } else {
            f14 = f3;
            f13 = f2;
        }
        if (f4 < f5) {
            f12 = f4;
            f11 = f5;
        } else {
            f12 = f5;
            f11 = f4;
        }
        if (f6 < f7) {
            f10 = f6;
            f9 = f7;
        } else {
            f10 = f7;
            f9 = f6;
        }
        int n2 = (int)Math.floor(f14);
        int n3 = (int)Math.ceil(f13);
        int n4 = (int)Math.floor(f12);
        int n5 = (int)Math.ceil(f11);
        int n6 = (int)Math.floor(f10);
        int n7 = (int)Math.ceil(f9);
        VoxelArray voxelArray = VoxelArray.construct(f14, f13, f12, f11, f10, f9, true);
        voxelArray.removeOutsideSphere(f14 + f8, f12 + f8, f10 + f8, f8, n2, Math.round(f14 + f8), n4, Math.round(f12 + f8), n6, Math.round(f10 + f8));
        voxelArray.removeOutsideSphere(f13 - f8, f12 + f8, f10 + f8, f8, Math.round(f13 - f8), n3, n4, Math.round(f12 + f8), n6, Math.round(f10 + f8));
        voxelArray.removeOutsideSphere(f14 + f8, f12 + f8, f9 - f8, f8, n2, Math.round(f14 + f8), n4, Math.round(f12 + f8), Math.round(f9 - f8), n7);
        voxelArray.removeOutsideSphere(f13 - f8, f12 + f8, f9 - f8, f8, Math.round(f13 - f8), n3, n4, Math.round(f12 + f8), Math.round(f9 - f8), n7);
        voxelArray.removeOutsideSphere(f14 + f8, f11 - f8, f10 + f8, f8, n2, Math.round(f14 + f8), Math.round(f11 - f8), n5, n6, Math.round(f10 + f8));
        voxelArray.removeOutsideSphere(f13 - f8, f11 - f8, f10 + f8, f8, Math.round(f13 - f8), n3, Math.round(f11 - f8), n5, n6, Math.round(f10 + f8));
        voxelArray.removeOutsideSphere(f14 + f8, f11 - f8, f9 - f8, f8, n2, Math.round(f14 + f8), Math.round(f11 - f8), n5, Math.round(f9 - f8), n7);
        voxelArray.removeOutsideSphere(f13 - f8, f11 - f8, f9 - f8, f8, Math.round(f13 - f8), n3, Math.round(f11 - f8), n5, Math.round(f9 - f8), n7);
        voxelArray.removeOutsideLine(f14 + f8, f12 + f8, f10 + f8, f13 - f8, f12 + f8, f10 + f8, f8, Math.round(f14 + f8) + 1, Math.round(f13 - f8) - 1, n4, Math.round(f12 + f8), n6, Math.round(f10 + f8));
        voxelArray.removeOutsideLine(f14 + f8, f11 - f8, f10 + f8, f13 - f8, f11 - f8, f10 + f8, f8, Math.round(f14 + f8) + 1, Math.round(f13 - f8) - 1, Math.round(f11 - f8), n5, n6, Math.round(f10 + f8));
        voxelArray.removeOutsideLine(f14 + f8, f12 + f8, f9 - f8, f13 - f8, f12 + f8, f9 - f8, f8, Math.round(f14 + f8) + 1, Math.round(f13 - f8) - 1, n4, Math.round(f12 + f8), Math.round(f9 - f8), n7);
        voxelArray.removeOutsideLine(f14 + f8, f11 - f8, f9 - f8, f13 - f8, f11 - f8, f9 - f8, f8, Math.round(f14 + f8) + 1, Math.round(f13 - f8) - 1, Math.round(f11 - f8), n5, Math.round(f9 - f8), n7);
        voxelArray.removeOutsideLine(f14 + f8, f12 + f8, f10 + f8, f14 + f8, f11 - f8, f10 + f8, f8, n2, Math.round(f14 + f8), Math.round(f12 + f8) + 1, Math.round(f11 - f8) - 1, n6, Math.round(f10 + f8));
        voxelArray.removeOutsideLine(f14 + f8, f12 + f8, f9 - f8, f14 + f8, f11 - f8, f9 - f8, f8, n2, Math.round(f14 + f8), Math.round(f12 + f8) + 1, Math.round(f11 - f8) - 1, Math.round(f9 - f8), n7);
        voxelArray.removeOutsideLine(f13 - f8, f12 + f8, f10 + f8, f13 - f8, f11 - f8, f10 + f8, f8, Math.round(f13 - f8), n3, Math.round(f12 + f8) + 1, Math.round(f11 - f8) - 1, n6, Math.round(f10 + f8));
        voxelArray.removeOutsideLine(f13 - f8, f12 + f8, f9 - f8, f13 - f8, f11 - f8, f9 - f8, f8, Math.round(f13 - f8), n3, Math.round(f12 + f8) + 1, Math.round(f11 - f8) - 1, Math.round(f9 - f8), n7);
        voxelArray.removeOutsideLine(f14 + f8, f12 + f8, f10 + f8, f14 + f8, f12 + f8, f9 - f8, f8, n2, Math.round(f14 + f8), n4, Math.round(f12 + f8), Math.round(f10 + f8) + 1, Math.round(f9 - f8) - 1);
        voxelArray.removeOutsideLine(f14 + f8, f11 - f8, f10 + f8, f14 + f8, f11 - f8, f9 - f8, f8, n2, Math.round(f14 + f8), Math.round(f11 - f8), n5, Math.round(f10 + f8) + 1, Math.round(f9 - f8) - 1);
        voxelArray.removeOutsideLine(f13 - f8, f11 - f8, f10 + f8, f13 - f8, f11 - f8, f9 - f8, f8, Math.round(f13 - f8), n3, Math.round(f11 - f8), n5, Math.round(f10 + f8) + 1, Math.round(f9 - f8) - 1);
        voxelArray.removeOutsideLine(f13 - f8, f12 + f8, f10 + f8, f13 - f8, f12 + f8, f9 - f8, f8, Math.round(f13 - f8), n3, n4, Math.round(f12 + f8), Math.round(f10 + f8) + 1, Math.round(f9 - f8) - 1);
        return voxelArray;
    }

    public void removeOutsideSphere(float f2, float f3, float f4, float f5, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f6 = f5 * f5;
        int n8 = n6;
        while (n8 <= n7) {
            float f7 = (f4 - (float)n8) * (f4 - (float)n8);
            int n9 = n4;
            while (n9 <= n5) {
                float f8 = (f3 - (float)n9) * (f3 - (float)n9);
                int n10 = n2;
                while (n10 <= n3) {
                    float f9 = (f2 - (float)n10) * (f2 - (float)n10);
                    if (f9 + f8 + f7 > f6) {
                        this.set(n10, n9, n8, false);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
    }

    public void removeOutsideLine(float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n2, int n3, int n4, int n5, int n6, int n7) {
        LineSegment3DFloat lineSegment3DFloat = new LineSegment3DFloat(f2, f3, f4, f5, f6, f7);
        Point3DFloat point3DFloat = new Point3DFloat(0.0f, 0.0f, 0.0f);
        int n8 = n6;
        while (n8 <= n7) {
            point3DFloat.z = n8;
            int n9 = n4;
            while (n9 <= n5) {
                point3DFloat.y = n9;
                int n10 = n2;
                while (n10 <= n3) {
                    point3DFloat.x = n10;
                    if (lineSegment3DFloat.distanceToLine(point3DFloat) > f8) {
                        this.set(n10, n9, n8, false);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VoxelArray paintAlongPath(Point3DIntList point3DIntList, VoxelArray voxelArray, int n2, int n3, int n4) {
        BoundingBox3DFloat boundingBox3DFloat = point3DIntList.getBoundingBox();
        boundingBox3DFloat = boundingBox3DFloat.expand(n2 - voxelArray.getMinX(), n3 - voxelArray.getMinY(), n4 - voxelArray.getMinZ(), voxelArray.getMaxX() - n2, voxelArray.getMaxY() - n3, voxelArray.getMaxZ() - n4);
        VoxelArray voxelArray2 = VoxelArray.construct(boundingBox3DFloat.getMinX(), boundingBox3DFloat.getMaxX(), boundingBox3DFloat.getMinY(), boundingBox3DFloat.getMaxY(), boundingBox3DFloat.getMinZ(), boundingBox3DFloat.getMaxZ(), false);
        int n5 = point3DIntList.getPointCount();
        int n6 = voxelArray.case;
        int n7 = voxelArray.byte;
        int n8 = voxelArray.try;
        int n9 = n2 - n6;
        int n10 = n3 - n7;
        int n11 = n4 - n8;
        try {
            int n12 = 0;
            while (n12 < n5) {
                Point3DInt point3DInt = point3DIntList.getPoint(n12);
                voxelArray.case = point3DInt.x - n9;
                voxelArray.byte = point3DInt.y - n10;
                voxelArray.try = point3DInt.z - n11;
                voxelArray2.add(voxelArray);
                ++n12;
            }
            Object var17_16 = null;
            voxelArray.case = n6;
            voxelArray.byte = n7;
            voxelArray.try = n8;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            voxelArray.case = n6;
            voxelArray.byte = n7;
            voxelArray.try = n8;
            throw throwable;
        }
        return voxelArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VoxelArray paintAlongAllPoints(VoxelArray voxelArray, VoxelArray voxelArray2, int n2, int n3, int n4) {
        VoxelArray voxelArray3 = VoxelArray.construct(voxelArray.getMinX() - (n2 - voxelArray2.getMinX()), voxelArray.getMaxX() + (voxelArray2.getMaxX() - n2), voxelArray.getMinY() - (n3 - voxelArray2.getMinY()), voxelArray.getMaxY() + (voxelArray2.getMaxY() - n3), voxelArray.getMinZ() - (n4 - voxelArray2.getMinZ()), voxelArray.getMaxZ() + (voxelArray2.getMaxZ() - n4), false);
        long[] lArray = new long[3];
        int n5 = voxelArray2.case;
        int n6 = voxelArray2.byte;
        int n7 = voxelArray2.try;
        long l2 = n2 - n5;
        long l3 = n3 - n6;
        long l4 = n4 - n7;
        long l5 = 0L;
        try {
            while ((l5 = voxelArray.getNextSetBitIndex(l5)) != -1L) {
                voxelArray.indexToXYZ(l5, lArray);
                voxelArray2.case = (int)(lArray[0] - l2);
                voxelArray2.byte = (int)(lArray[1] - l3);
                voxelArray2.try = (int)(lArray[2] - l4);
                voxelArray3.add(voxelArray2);
                ++l5;
            }
            Object var19_14 = null;
            voxelArray2.case = n5;
            voxelArray2.byte = n6;
            voxelArray2.try = n7;
        }
        catch (Throwable throwable) {
            Object var19_15 = null;
            voxelArray2.case = n5;
            voxelArray2.byte = n6;
            voxelArray2.try = n7;
            throw throwable;
        }
        return voxelArray3;
    }

    public VoxelArray paintAlongHull(VoxelArray voxelArray, int n2, int n3, int n4, boolean bl2) {
        Point3DIntList point3DIntList = this.hullPoints();
        VoxelArray voxelArray2 = VoxelArray.paintAlongPath(point3DIntList, voxelArray, n2, n3, n4);
        if (bl2) {
            return this.union(voxelArray2);
        }
        VoxelArray voxelArray3 = new VoxelArray(this);
        voxelArray3.remove(voxelArray2);
        return voxelArray3;
    }

    public VoxelArray transform(CoordinateTransformer3DFloat coordinateTransformer3DFloat) throws az {
        Point3DFloat point3DFloat = new Point3DFloat(0.0f, 0.0f, 0.0f);
        BoundingBox3DFloat boundingBox3DFloat = new BoundingBox3DFloat();
        boundingBox3DFloat.addPoint(coordinateTransformer3DFloat.transform(this.getMinX(), this.getMinY(), this.getMinZ(), point3DFloat));
        boundingBox3DFloat.addPoint(coordinateTransformer3DFloat.transform(this.getMinX(), this.getMinY(), this.getMaxZ(), point3DFloat));
        boundingBox3DFloat.addPoint(coordinateTransformer3DFloat.transform(this.getMinX(), this.getMaxY(), this.getMinZ(), point3DFloat));
        boundingBox3DFloat.addPoint(coordinateTransformer3DFloat.transform(this.getMinX(), this.getMaxY(), this.getMaxZ(), point3DFloat));
        boundingBox3DFloat.addPoint(coordinateTransformer3DFloat.transform(this.getMaxX(), this.getMinY(), this.getMinZ(), point3DFloat));
        boundingBox3DFloat.addPoint(coordinateTransformer3DFloat.transform(this.getMaxX(), this.getMinY(), this.getMaxZ(), point3DFloat));
        boundingBox3DFloat.addPoint(coordinateTransformer3DFloat.transform(this.getMaxX(), this.getMaxY(), this.getMinZ(), point3DFloat));
        boundingBox3DFloat.addPoint(coordinateTransformer3DFloat.transform(this.getMaxX(), this.getMaxY(), this.getMaxZ(), point3DFloat));
        CoordinateTransformer3DFloat coordinateTransformer3DFloat2 = coordinateTransformer3DFloat.inverse();
        VoxelArray voxelArray = VoxelArray.construct(boundingBox3DFloat, false);
        int n2 = voxelArray.getMinX();
        int n3 = voxelArray.getMinY();
        int n4 = voxelArray.getMinZ();
        int n5 = voxelArray.getMaxX();
        int n6 = voxelArray.getMaxY();
        int n7 = voxelArray.getMaxZ();
        int n8 = n4;
        while (n8 <= n7) {
            int n9 = n3;
            while (n9 <= n6) {
                int n10 = n2;
                while (n10 <= n5) {
                    coordinateTransformer3DFloat2.transform(n10, n9, n8, point3DFloat);
                    int n11 = Math.round(point3DFloat.x);
                    int n12 = Math.round(point3DFloat.y);
                    int n13 = Math.round(point3DFloat.z);
                    if (this.isInRange(n11, n12, n13) && this.a(n11, n12, n13)) {
                        voxelArray.set(n10, n9, n8, true);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
        return voxelArray;
    }

    public VoxelArray rotate(float f2, float f3, float f4, float f5, float f6, float f7, double d2) throws az {
        CoordinateTransformer3DFloat coordinateTransformer3DFloat = CoordinateTransformer3DFloat.makeRotate(f2, f3, f4, f5, f6, f7, d2);
        return this.transform(coordinateTransformer3DFloat);
    }

    public VoxelArray rotateXYZ(float f2, float f3, float f4, double d2, double d3, double d4) throws az {
        CoordinateTransformer3DFloat coordinateTransformer3DFloat = CoordinateTransformer3DFloat.makeRotateXYZ(f2, f3, f4, d2, d3, d4);
        return this.transform(coordinateTransformer3DFloat);
    }

    public static VoxelArray makeSupertoroid(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = 2.0 / d6;
        double d9 = 2.0 / d7;
        double d10 = d7 / 2.0;
        double d11 = d2 * Math.sqrt(2.0);
        double d12 = d11 / Math.sqrt(d3 * d3 + d4 * d4);
        double d13 = d3 * (d12 + 1.0);
        double d14 = d4 * (d12 + 1.0);
        double d15 = d5;
        VoxelArray voxelArray = VoxelArray.construct(-d13, d13, -d14, d14, -d15, d15, false);
        int n2 = voxelArray.getMinX();
        int n3 = voxelArray.getMaxX();
        int n4 = voxelArray.getMinY();
        int n5 = voxelArray.getMaxY();
        int n6 = voxelArray.getMinZ();
        int n7 = voxelArray.getMaxZ();
        int n8 = 0;
        while (n8 <= n7) {
            int n9 = 0;
            while (n9 <= n5) {
                int n10 = 0;
                while (n10 <= n3) {
                    double d16 = Math.pow(Math.abs(Math.pow(Math.pow((double)n10 / d3, d9) + Math.pow((double)n9 / d4, d9), d10) - d12), d8) + Math.pow((double)n8 / d5, d8);
                    if (d16 <= 1.0) {
                        voxelArray.set(n10, n9, n8, true);
                        voxelArray.set(n10, n9, -n8, true);
                        voxelArray.set(n10, -n9, n8, true);
                        voxelArray.set(n10, -n9, -n8, true);
                        voxelArray.set(-n10, n9, n8, true);
                        voxelArray.set(-n10, n9, -n8, true);
                        voxelArray.set(-n10, -n9, n8, true);
                        voxelArray.set(-n10, -n9, -n8, true);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
        return voxelArray;
    }

    public static VoxelArray makeSuperellipsoid(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 2.0 / d5;
        double d8 = 2.0 / d6;
        double d9 = d6 / d5;
        VoxelArray voxelArray = VoxelArray.construct(-d2, d2, -d3, d3, -d4, d4, false);
        int n2 = voxelArray.getMinX();
        int n3 = voxelArray.getMaxX();
        int n4 = voxelArray.getMinY();
        int n5 = voxelArray.getMaxY();
        int n6 = voxelArray.getMinZ();
        int n7 = voxelArray.getMaxZ();
        int n8 = 0;
        while (n8 <= n7) {
            double d10 = Math.pow(Math.abs((double)n8 / d4), d7);
            int n9 = 0;
            while (n9 <= n5) {
                double d11 = Math.pow(Math.abs((double)n9 / d3), d8);
                int n10 = 0;
                while (n10 <= n3) {
                    double d12 = Math.pow(Math.pow(Math.abs((double)n10 / d2), d8) + d11, d9) + d10;
                    if (d12 <= 1.0) {
                        voxelArray.set(n10, n9, n8, true);
                        voxelArray.set(n10, n9, -n8, true);
                        voxelArray.set(n10, -n9, n8, true);
                        voxelArray.set(n10, -n9, -n8, true);
                        voxelArray.set(-n10, n9, n8, true);
                        voxelArray.set(-n10, n9, -n8, true);
                        voxelArray.set(-n10, -n9, n8, true);
                        voxelArray.set(-n10, -n9, -n8, true);
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
        return voxelArray;
    }

    public long getNextSetBitIndex(long l2) {
        return this.new.nextSetBit(l2);
    }

    public long getPreviousSetBitIndex(long l2) {
        return this.new.previousSetBit(l2);
    }

    public int getMinSetZ() {
        long l2 = this.getNextSetBitIndex(0L);
        if (l2 < 0L) {
            return this.getMaxZ();
        }
        return (int)(l2 / this.do + (long)this.try);
    }

    public int getMaxSetZ() {
        long l2 = this.getPreviousSetBitIndex(this.do * (long)this.a - 1L);
        if (l2 < 0L) {
            return this.getMinZ();
        }
        return (int)(l2 / this.do + (long)this.try);
    }

    public Point3DInt getMinimumSetPoints() {
        int n2 = this.getMinSetZ();
        int n3 = this.getMaxSetZ();
        int n4 = this.getMaxX();
        int n5 = this.getMaxY();
        int n6 = this.getMaxX();
        int n7 = this.getMaxY();
        int n8 = this.getMinY();
        block0: while (n8 <= n7) {
            int n9 = n2;
            while (n9 <= n3) {
                int n10 = this.getMinX();
                while (n10 < n6) {
                    if (this.a(n10, n8, n9)) {
                        n5 = n8;
                        break block0;
                    }
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
        int n11 = this.getMinX();
        block3: while (n11 <= n6) {
            int n12 = n2;
            while (n12 <= n3) {
                int n13 = this.getMinY();
                while (n13 <= n7) {
                    if (this.a(n11, n13, n12)) {
                        n4 = n11;
                        break block3;
                    }
                    ++n13;
                }
                ++n12;
            }
            ++n11;
        }
        return new Point3DInt(n4, n5, n2);
    }

    public Point3DInt getMaximumSetPoints() {
        int n2;
        int n3 = this.getMinSetZ();
        int n4 = this.getMaxSetZ();
        int n5 = this.getMinX();
        int n6 = this.getMinY();
        int n7 = this.getMinX();
        int n8 = this.getMinY();
        int n9 = this.getMaxX();
        int n10 = n2 = this.getMaxY();
        block0: while (n10 >= n8) {
            int n11 = n3;
            while (n11 <= n4) {
                int n12 = n7;
                while (n12 <= n9) {
                    if (this.a(n12, n10, n11)) {
                        n6 = n10;
                        break block0;
                    }
                    ++n12;
                }
                ++n11;
            }
            --n10;
        }
        int n13 = n9;
        block3: while (n13 >= n7) {
            int n14 = n3;
            while (n14 <= n4) {
                int n15 = n8;
                while (n15 <= n2) {
                    if (this.a(n13, n15, n14)) {
                        n5 = n13;
                        break block3;
                    }
                    ++n15;
                }
                ++n14;
            }
            --n13;
        }
        return new Point3DInt(n5, n6, n4);
    }

    public Point3DInt farthestSetPoint(LineSegment3DFloat lineSegment3DFloat) {
        int n2 = this.getMaxX();
        int n3 = this.getMaxY();
        int n4 = this.getMaxZ();
        int n5 = this.getMinSetZ();
        Point3DFloat point3DFloat = new Point3DFloat(n2, n3, n4);
        Point3DInt point3DInt = new Point3DInt(n2, n3, n4);
        float f2 = 0.0f;
        int n6 = n5;
        while (n6 <= n4) {
            point3DFloat.z = n6;
            int n7 = this.getMinY();
            while (n7 <= n3) {
                point3DFloat.y = n7;
                int n8 = this.getMinX();
                while (n8 <= n2) {
                    if (this.a(n8, n7, n6)) {
                        point3DFloat.x = n8;
                        float f3 = lineSegment3DFloat.distanceToLine(point3DFloat);
                        if (f3 > f2) {
                            f2 = f3;
                            point3DInt.x = n8;
                            point3DInt.y = n7;
                            point3DInt.z = n6;
                        }
                    }
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        return point3DInt;
    }

    public VoxelArray solidOfRotation(LineSegment3DFloat lineSegment3DFloat, double d2, double d3) throws az {
        float f2 = lineSegment3DFloat.p1.x;
        float f3 = lineSegment3DFloat.p1.y;
        float f4 = lineSegment3DFloat.p1.z;
        float f5 = lineSegment3DFloat.p2.x - f2;
        float f6 = lineSegment3DFloat.p2.y - f3;
        float f7 = lineSegment3DFloat.p2.z - f4;
        return this.solidOfRotation(f2, f3, f4, f5, f6, f7, d2, d3);
    }

    public VoxelArray solidOfRotation(Point3DFloat point3DFloat, Point3DFloat point3DFloat2, double d2, double d3) throws az {
        return this.solidOfRotation(point3DFloat.x, point3DFloat.y, point3DFloat.z, point3DFloat2.x, point3DFloat2.y, point3DFloat2.z, d2, d3);
    }

    public VoxelArray solidOfRotation(float f2, float f3, float f4, float f5, float f6, float f7, double d2, double d3) throws az {
        VoxelArray voxelArray;
        if (d2 > d3) {
            double d4 = d2;
            d2 = d3;
            d3 = d4;
        }
        LineSegment3DFloat lineSegment3DFloat = LineSegment3DFloat.pointAndNormal(f2, f3, f4, f5, f6, f7);
        Point3DInt point3DInt = this.farthestSetPoint(lineSegment3DFloat);
        float f8 = lineSegment3DFloat.distanceToLine(new Point3DFloat(point3DInt));
        double d5 = Math.atan(1.0 / (double)f8);
        VoxelArray voxelArray2 = null;
        double d6 = d2;
        while (d6 <= d3) {
            voxelArray = this.rotate(f2, f3, f4, f5, f6, f7, d6);
            voxelArray2 = voxelArray2 == null ? voxelArray : voxelArray2.union(voxelArray);
            d6 += d5;
        }
        voxelArray = this.rotate(f2, f3, f4, f5, f6, f7, d3);
        voxelArray2 = voxelArray2 == null ? voxelArray : voxelArray2.union(voxelArray);
        return voxelArray2;
    }

    public VoxelArray cylindricalEmboss(FrinkImage frinkImage, float f2, float f3, float f4, double d2, double d3, float f5, float f6, float f7, VoxelArray voxelArray, int n2, int n3, int n4) {
        return this.cylindricalEmboss(frinkImage, f2, f3, f4, d2, d3, f5, 0, 64, f6, f6, f7, f7, voxelArray, n2, n3, n4);
    }

    public VoxelArray cylindricalEmboss(FrinkImage frinkImage, float f2, float f3, float f4, double d2, double d3, float f5, int n2, int n3, float f6, float f7, float f8, float f9, VoxelArray voxelArray, int n4, int n5, int n6) {
        LineSegment3DFloat lineSegment3DFloat;
        Point3DInt point3DInt;
        int n7 = frinkImage.getWidth();
        int n8 = frinkImage.getHeight();
        d2 = this.a(d2, Math.PI * 2);
        double d4 = d2 - d3 / 2.0;
        double d5 = d2 + d3 / 2.0;
        boolean bl2 = d4 <= Math.PI && d5 > Math.PI;
        double d6 = d3 / (double)n7;
        double d7 = f5 / (float)n8;
        double d8 = f3 - f5 / 2.0f;
        double d9 = f3 + f5 / 2.0f;
        VoxelArray voxelArray2 = null;
        Point3DIntList point3DIntList = this.externalHullPoints();
        int n9 = point3DIntList.getPointCount();
        Point3DDouble point3DDouble = new Point3DDouble(0.0, 0.0, 0.0);
        float f10 = n3 - n2;
        float f11 = f7 - f6;
        float f12 = f9 - f8;
        Vector<LineSegment3DFloat> vector = new Vector<LineSegment3DFloat>();
        BoundingBox3DFloat boundingBox3DFloat = new BoundingBox3DFloat();
        int n10 = 0;
        while (n10 < n9) {
            int n11;
            int n12;
            double d10;
            point3DInt = point3DIntList.getPoint(n10);
            point3DDouble = Point3DFloat.toCylindrical(point3DInt.x, point3DInt.y, point3DInt.z, f2, f3, f4, point3DDouble);
            double d11 = -point3DDouble.y;
            if (d5 > Math.PI * 2 && (d10 = this.a(d11, Math.PI * 2) + Math.PI * 2) <= d5) {
                d11 = d10;
            }
            if (bl2 && d11 < 0.0 && (d10 = d11 + Math.PI * 2) < d5) {
                d11 = d10;
            }
            if ((n12 = (int)Math.floor((d11 - d4) / d6)) >= 0 && n12 < n7 && (n11 = (int)Math.floor((d9 - point3DDouble.z) / d7)) >= 0 && n11 < n8) {
                short s2;
                try {
                    s2 = bl.a(frinkImage.getPixelPacked(n12, n11), 255);
                }
                catch (be be2) {
                    System.err.println("VoxelArray.cylindricalEmboss:  converting this image to grayscale is not supported by your JVM.");
                    return null;
                }
                if (s2 >= n2 && s2 <= n3) {
                    float f13 = (float)(s2 - n2) / f10;
                    float f14 = f6 + f11 * f13;
                    float f15 = f8 + f12 * f13;
                    lineSegment3DFloat = LineSegment3DFloat.towardPoint(point3DInt.x, point3DInt.y, point3DInt.z, f2, f3, point3DInt.z, f14, f15);
                    vector.addElement(lineSegment3DFloat);
                    boundingBox3DFloat.union(lineSegment3DFloat.getBoundingBox());
                }
            }
            ++n10;
        }
        int n13 = vector.size();
        VoxelArray voxelArray3 = VoxelArray.construct(boundingBox3DFloat, false);
        int n14 = 0;
        while (n14 < n13) {
            lineSegment3DFloat = (LineSegment3DFloat)vector.elementAt(n14);
            Point3DIntList point3DIntList2 = LinePoints.line3DInt(lineSegment3DFloat);
            int n15 = point3DIntList2.getPointCount();
            int n16 = 0;
            while (n16 < n15) {
                point3DInt = point3DIntList2.getPoint(n16);
                voxelArray3.set(point3DInt, true);
                ++n16;
            }
            ++n14;
        }
        voxelArray2 = VoxelArray.paintAlongAllPoints(voxelArray3, voxelArray, n4, n5, n6);
        return voxelArray2;
    }

    public VoxelArray sphericalEmboss(FrinkImage frinkImage, float f2, float f3, float f4, double d2, double d3, double d4, double d5, float f5, float f6, VoxelArray voxelArray, int n2, int n3, int n4) {
        return this.sphericalEmboss(frinkImage, f2, f3, f4, d2, d3, d4, d5, 0, 64, f5, f5, f6, f6, voxelArray, n2, n3, n4);
    }

    public VoxelArray sphericalEmboss(FrinkImage frinkImage, float f2, float f3, float f4, double d2, double d3, double d4, double d5, int n2, int n3, float f5, float f6, float f7, float f8, VoxelArray voxelArray, int n4, int n5, int n6) {
        LineSegment3DFloat lineSegment3DFloat;
        Point3DInt point3DInt;
        int n7 = frinkImage.getWidth();
        int n8 = frinkImage.getHeight();
        d2 = this.a(d2, Math.PI * 2);
        double d6 = d2 - d3 / 2.0;
        double d7 = d2 + d3 / 2.0;
        boolean bl2 = d6 <= Math.PI && d7 > Math.PI;
        double d8 = d3 / (double)n7;
        double d9 = d5 / (double)n8;
        double d10 = (double)f3 - d5 / 2.0 + d4;
        double d11 = (double)f3 + d5 / 2.0 + d4;
        VoxelArray voxelArray2 = null;
        Point3DIntList point3DIntList = this.externalHullPoints();
        int n9 = point3DIntList.getPointCount();
        Point3DDouble point3DDouble = new Point3DDouble(0.0, 0.0, 0.0);
        float f9 = n3 - n2;
        float f10 = f6 - f5;
        float f11 = f8 - f7;
        Vector<LineSegment3DFloat> vector = new Vector<LineSegment3DFloat>();
        BoundingBox3DFloat boundingBox3DFloat = new BoundingBox3DFloat();
        int n10 = 0;
        while (n10 < n9) {
            int n11;
            int n12;
            double d12;
            point3DInt = point3DIntList.getPoint(n10);
            point3DDouble = Point3DFloat.toAltAz(point3DInt.x, point3DInt.y, point3DInt.z, f2, f3, f4, point3DDouble);
            double d13 = -point3DDouble.z;
            double d14 = point3DDouble.y;
            if (d7 > Math.PI * 2 && (d12 = this.a(d13, Math.PI * 2) + Math.PI * 2) <= d7) {
                d13 = d12;
            }
            if (bl2 && d13 < 0.0 && (d12 = d13 + Math.PI * 2) < d7) {
                d13 = d12;
            }
            if ((n12 = (int)Math.floor((d13 - d6) / d8)) >= 0 && n12 < n7 && (n11 = (int)Math.floor((d11 - d14) / d9)) >= 0 && n11 < n8) {
                short s2;
                try {
                    s2 = bl.a(frinkImage.getPixelPacked(n12, n11), 255);
                }
                catch (be be2) {
                    System.err.println("VoxelArray.cylindricalEmboss:  converting this image to grayscale is not supported by your JVM.");
                    return null;
                }
                if (s2 >= n2 && s2 <= n3) {
                    float f12 = (float)(s2 - n2) / f9;
                    float f13 = f5 + f10 * f12;
                    float f14 = f7 + f11 * f12;
                    lineSegment3DFloat = LineSegment3DFloat.towardPoint(point3DInt.x, point3DInt.y, point3DInt.z, f2, f3, f4, f13, f14);
                    vector.addElement(lineSegment3DFloat);
                    boundingBox3DFloat.union(lineSegment3DFloat.getBoundingBox());
                }
            }
            ++n10;
        }
        int n13 = vector.size();
        VoxelArray voxelArray3 = VoxelArray.construct(boundingBox3DFloat, false);
        int n14 = 0;
        while (n14 < n13) {
            lineSegment3DFloat = (LineSegment3DFloat)vector.elementAt(n14);
            Point3DIntList point3DIntList2 = LinePoints.line3DInt(lineSegment3DFloat);
            int n15 = point3DIntList2.getPointCount();
            int n16 = 0;
            while (n16 < n15) {
                point3DInt = point3DIntList2.getPoint(n16);
                voxelArray3.set(point3DInt, true);
                ++n16;
            }
            ++n14;
        }
        voxelArray2 = VoxelArray.paintAlongAllPoints(voxelArray3, voxelArray, n4, n5, n6);
        return voxelArray2;
    }

    public VoxelArray planarEmboss(FrinkImage frinkImage, float f2, float f3, float f4, float f5, int n2, int n3, float f6, float f7, float f8, float f9, VoxelArray voxelArray, int n4, int n5, int n6) {
        LineSegment3DFloat lineSegment3DFloat;
        int n7;
        int n8 = frinkImage.getWidth();
        int n9 = frinkImage.getHeight();
        double d2 = (double)f2 - (double)f4 / 2.0;
        double d3 = (double)f2 + (double)f4 / 2.0;
        double d4 = (double)f3 - (double)f5 / 2.0;
        double d5 = (double)f3 + (double)f5 / 2.0;
        double d6 = (float)n8 / f4;
        double d7 = (float)n9 / f5;
        VoxelArray voxelArray2 = null;
        Point3DDouble point3DDouble = new Point3DDouble(0.0, 0.0, 0.0);
        float f10 = n3 - n2;
        float f11 = f7 - f6;
        float f12 = f9 - f8;
        Vector<LineSegment3DFloat> vector = new Vector<LineSegment3DFloat>();
        BoundingBox3DFloat boundingBox3DFloat = new BoundingBox3DFloat();
        int n10 = this.getMinX();
        int n11 = this.getMaxX();
        int n12 = this.getMinY();
        int n13 = this.getMaxY();
        int n14 = this.getMinSetZ();
        int n15 = this.getMaxSetZ();
        int n16 = n12;
        while (n16 <= n13) {
            int n17 = (int)Math.floor((d5 - (double)n16) * d7);
            if (n17 >= 0 && n17 < n9) {
                n7 = n10;
                while (n7 <= n11) {
                    int n18 = (int)Math.floor(((double)n7 - d2) * d6);
                    if (n18 >= 0 && n18 < n8) {
                        short s2;
                        try {
                            s2 = bl.a(frinkImage.getPixelPacked(n18, n17), 255);
                        }
                        catch (be be2) {
                            System.err.println("VoxelArray.planarEmboss:  converting this image to grayscale is not supported by your JVM.");
                            return null;
                        }
                        if (s2 >= n2 && s2 <= n3) {
                            int n19 = n15;
                            while (n19 >= n14) {
                                if (this.a(n7, n16, n19)) {
                                    float f13 = (float)(s2 - n2) / f10;
                                    float f14 = f6 + f11 * f13;
                                    float f15 = f8 + f12 * f13;
                                    lineSegment3DFloat = LineSegment3DFloat.towardPoint(n7, n16, n19, n7, n16, n14 - 1, f14, f15);
                                    vector.addElement(lineSegment3DFloat);
                                    boundingBox3DFloat.union(lineSegment3DFloat.getBoundingBox());
                                    break;
                                }
                                --n19;
                            }
                        }
                    }
                    ++n7;
                }
            }
            ++n16;
        }
        n7 = vector.size();
        VoxelArray voxelArray3 = VoxelArray.construct(boundingBox3DFloat, false);
        int n20 = 0;
        while (n20 < n7) {
            lineSegment3DFloat = (LineSegment3DFloat)vector.elementAt(n20);
            Point3DIntList point3DIntList = LinePoints.line3DInt(lineSegment3DFloat);
            int n21 = point3DIntList.getPointCount();
            int n22 = 0;
            while (n22 < n21) {
                Point3DInt point3DInt = point3DIntList.getPoint(n22);
                voxelArray3.set(point3DInt, true);
                ++n22;
            }
            ++n20;
        }
        voxelArray2 = VoxelArray.paintAlongAllPoints(voxelArray3, voxelArray, n4, n5, n6);
        return voxelArray2;
    }

    public long countSetBits() {
        return this.new.cardinality();
    }

    private double a(double d2, double d3) {
        return d2 - d3 * Math.floor(d2 / d3);
    }

    public Point3DDouble centerOfMass() {
        long[] lArray = new long[3];
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        while ((l5 = this.getNextSetBitIndex(l5)) != -1L) {
            this.indexToXYZ(l5, lArray);
            l2 += lArray[0];
            l3 += lArray[1];
            l4 += lArray[2];
            ++l5;
        }
        double d2 = this.countSetBits();
        return new Point3DDouble((double)l2 / d2, (double)l3 / d2, (double)l4 / d2);
    }
}

