/*
 * Decompiled with CFR 0.152.
 */
package frink.graphics;

import frink.graphics.Point3DFloat;
import frink.graphics.Triangle3DFloat;
import java.text.DecimalFormat;
import java.util.Vector;

public class STLFormatter {
    private static final DecimalFormat a = new DecimalFormat("#.#####");

    public static String toSTLFormat(Vector vector, String string, float f2) {
        int n2 = vector.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("solid " + string + "\n");
        int n3 = 0;
        while (n3 < n2) {
            Triangle3DFloat triangle3DFloat = (Triangle3DFloat)vector.elementAt(n3);
            stringBuffer.append(" facet normal 0 0 0\n");
            stringBuffer.append("  outer loop\n");
            int n4 = 0;
            while (n4 <= 2) {
                Point3DFloat point3DFloat = triangle3DFloat.vertex[n4];
                stringBuffer.append("   vertex " + a.format(point3DFloat.x * f2) + " " + a.format(point3DFloat.y * f2) + " " + a.format(point3DFloat.z * f2) + "\n");
                ++n4;
            }
            stringBuffer.append("  endloop\n");
            stringBuffer.append(" endfacet\n");
            ++n3;
        }
        stringBuffer.append("endsolid " + string + "\n");
        return new String(stringBuffer);
    }

    public static String toSTLFormat(Vector vector, String string) {
        return STLFormatter.toSTLFormat(vector, string, 1.0f);
    }
}

